/***********************************************************************************************//**
 * @file		cangw.hpp
 * @brief		Header file for cangw.cpp
 * @date		2014-03-07
 * @copyright	Hatteland Display AS
 **************************************************************************************************/

//==================================================================================================
// Includes
//==================================================================================================
#include <hdj2534.h>

//==================================================================================================
// Defines
//==================================================================================================


//==================================================================================================
// Typedefs
//==================================================================================================
/// Namespace for cangw module
namespace canGw
{
	/// Definition of CAN Gateway's error codes
	enum ErrCode_e
	{
		/// No error
		CAN_GW_OK,
		/// An error occurred
		CAN_GW_ERR
	};

	/// Definition of CAN Gateway channels' names
	enum Channel_e
	{
		/// Name of CAN Gateway's channel 1
		CHANNEL_1,
		/// Name of CAN Gateway's channel 2
		CHANNEL_2
	};

	/// Definition of CAN Gateway's baud rates
	enum Baudrate_e
	{
		/// Baudrate 125 kbps
		BAUD_125K,
		/// Baudrate 250 kbps
		BAUD_250K,
		/// Baudrate 500 kbps
		BAUD_500K,
		/// Baudrate 1 Mbps
		BAUD_1M
	};

	/// Definition of callback function for receive frames
	typedef void (* RcvCb_t)(const J2534::PASSTHRU_MSG * rxPassThruMsg, unsigned long rxMsgNum);
}

//==================================================================================================
// Exported variables
//==================================================================================================


//==================================================================================================
// Declarations of functions
//==================================================================================================
namespace canGw
{
	ErrCode_e init(Baudrate_e baudChan1, Baudrate_e baudChan2, const RcvCb_t cbChan1,
			const RcvCb_t cbChan2);
	ErrCode_e uninit();
	ErrCode_e send(Channel_e channel, J2534::PASSTHRU_MSG * txPassThruMsg);
	ErrCode_e startPeriodic(Channel_e channel, J2534::PASSTHRU_MSG * txPassThruMsg,
			unsigned long interval);
}
/**************************************************************************************************/
